--From: http://mini.pld.ttu.ee/~lrv/IAY0150/multiplier/multiplier1.vhd
------------------------------------------------------------------------
-- 8x8->16-bit unsigned sequential radix-2 multiplier
--   bit-by-bit calculation; no start/ready signals
--   behavioral-RTL style, OK for Xilinx ISE (10.1)
-- L(R)V - 2009
------------------------------------------------------------------------
library IEEE;
use IEEE.std_logic_1164.all;
use IEEE.std_logic_arith.all;

entity multiplier is
  port ( clk, rst: in bit;
	  rdy: out bit := '1';
         a, b: in unsigned(0 to 7);
            c: out unsigned(0 to 15) := (others=>'0') );
end entity multiplier;

architecture bhv of multiplier is
begin
  process
    variable a_bf, b_bf: unsigned(0 to 7);
    variable c_bf: unsigned(0 to 15);
    procedure mul_bit ( variable a: in unsigned(0 to 7);
                        variable b: inout unsigned(0 to 7);
                        variable c: inout unsigned(0 to 15) ) is
    begin
       c := c(1 to 15) & '0';
       if  b(0)='1'  then    c := c + a;    end if;
       b := b(1 to 7) & '0';
    end procedure mul_bit;
  begin
    wait on clk until clk='1' and rst='0';

    a_bf := a;  b_bf := b;  c_bf := (others=>'0'); 
    rdy <= '0';
    wait on clk until clk='1';

    mul_bit(a_bf,b_bf,c_bf);    wait on clk until clk='1';
    mul_bit(a_bf,b_bf,c_bf);    wait on clk until clk='1';
    mul_bit(a_bf,b_bf,c_bf);    wait on clk until clk='1';
    mul_bit(a_bf,b_bf,c_bf);    wait on clk until clk='1';
    mul_bit(a_bf,b_bf,c_bf);    wait on clk until clk='1';
    mul_bit(a_bf,b_bf,c_bf);    wait on clk until clk='1';
    mul_bit(a_bf,b_bf,c_bf);    wait on clk until clk='1';
    mul_bit(a_bf,b_bf,c_bf);    wait on clk until clk='1';
    c <= c_bf;     
    rdy <= '1';
    wait on clk until clk='1';
  end process;

end architecture bhv;